#include <nds.h>
#include <nds/arm9/console.h>
#include <nds/arm9/video.h>
#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <stdarg.h>
#include <nds/arm9/ndsmotion.h>


#include "piece.h"
#include "font.h"

volatile int frame = 0;

#define SWITCH_SCREENS  (1<<15)
#define TURNOFF_BACKLIT_BOTTOM	BIT(2)
#define TURNOFF_BACKLIT_TOP		BIT(3)

void Vblank() {
	frame++;
}





int i;

u16 pal[4] = { 
	RGB15(31,31,31) | BIT(15),
	RGB15(21,21,21) | BIT(15),
	RGB15(12,12,12) | BIT(15),
	RGB15(0,0,0) | BIT(15),
};





unsigned char *vBuffer = NULL;

void pceLCDDispStop()
{
}

void pceLCDDispStart()
{
}

void initSDL() {
	//doesn't use SDL 
}

void pceLCDTrans() {
	int x, y;


	for(y = 0; y < 88; y ++) {
		for(x = 0; x < 128; x ++) {
			BG_GFX[x+y*256] = pal[vBuffer[x+y*128]];
			
		}
	}
	
	
}

unsigned char *keys;

int pcePadGet() {

	static int pad = 0;
	int i = 0, op = pad & 0x00ff;

	int k[] = {
		KEY_UP,			KEY_DOWN,			KEY_LEFT,			KEY_RIGHT,
		KEY_UP,			KEY_DOWN,			KEY_LEFT,			KEY_RIGHT,
		KEY_A,			KEY_B,			    KEY_X,			    KEY_Y,
		KEY_START,		KEY_SELECT,			KEY_SELECT
	};

	int p[] = {
		PAD_UP,			PAD_DN,			PAD_LF,			PAD_RI,
		PAD_UP,			PAD_DN,			PAD_LF,			PAD_RI,
		PAD_A,			PAD_B,			PAD_A,			PAD_B,
		PAD_C,			PAD_D,			PAD_D,
		-1
	};

	pad = 0;
	scanKeys();
	do {
		scanKeys();
		if(keysHeld()&k[i]) {
			pad |= p[i];
		}
		i ++;
	} while(p[i] >= 0);

	pad |= (pad & (~op)) << 8;

	return pad;
}

int interval = 0;

void pceAppSetProcPeriod(int period) {
	interval = period;
}

int exec = 1;

void pceAppReqExit(int c) {
	exec = 0;
}

unsigned char *pceLCDSetBuffer(unsigned char *pbuff)
{
	if(pbuff) {
		vBuffer = pbuff;
	}
	return vBuffer;
}

int font_posX = 0, font_posY = 0, font_width = 4, font_height = 6;
unsigned char font_fgcolor = 3, font_bgcolor = 0, font_bgclear = 0;
const unsigned char *font_adr = FONT6;

void pceFontSetType(int type)
{
	const int width[] = {5, 8, 4};
	const int height[] = {10, 16, 6};
	const unsigned char* adr[] ={FONT6, FONT16, FONT6};

	type &= 3;
	font_width = width[type];
	font_height = height[type];
	font_adr = adr[type];
}

void pceFontSetTxColor(int color)
{
	font_fgcolor = (unsigned char)color;
}

void pceFontSetBkColor(int color)
{
	if(color >= 0) {
		font_bgcolor = (unsigned char)color;
		font_bgclear = 0;
	} else {
		font_bgclear = 1;
	}
}

void pceFontSetPos(int x, int y)
{
	font_posX = x;
	font_posY = y;
}

int pceFontPrintf(const char *fmt, ...)
{
	unsigned char *adr = vBuffer + font_posX + font_posY * 128;
	unsigned char *pC;
	unsigned char c[1024];

	va_list argp;

	va_start(argp, fmt);
	vsprintf(c, fmt, argp);
	va_end(argp);

	pC = c;
	while(*pC) {
		int i, x, y;
		const unsigned char *sAdr;
		if(*pC >= 0x20 && *pC < 0x80) {
			i = *pC - 0x20;
		} else {
			i = 0;
		}
		sAdr = font_adr + (i & 15) + (i >> 4) * 16 * 16;
		for(y = 0; y < font_height; y ++) {
			unsigned char c = *sAdr;
			for(x = 0; x < font_width; x ++) {
				if(c & 0x80) {
					*adr = font_fgcolor;
				} else if(font_bgclear == 0) {
					*adr = font_bgcolor;
				}
				adr ++;
				c <<= 1;
			}
			adr += 128 - font_width;
			sAdr += 16;
		}
		adr -= 128 * font_height - font_width;
		pC ++;
	}
	return 1;
}



u8 k_hit;

int cnt;
int main(void) {
	powerON(POWER_ALL);
    REG_POWERCNT = POWER_ALL_2D;
 	REG_POWERCNT &= ~SWITCH_SCREENS; 
 	VRAM_A_CR=VRAM_ENABLE|VRAM_A_MAIN_BG_0x06000000; 
	VRAM_B_CR=VRAM_ENABLE|VRAM_B_LCD; 
	VRAM_C_CR=VRAM_ENABLE|VRAM_C_SUB_BG;
	VRAM_D_CR=VRAM_ENABLE|VRAM_D_LCD; 
	irqInit();
	irqSet(IRQ_VBLANK, Vblank);
	irqEnable(IRQ_VBLANK);
	videoSetMode(MODE_5_2D | DISPLAY_BG3_ACTIVE);	
	videoSetModeSub(MODE_0_2D | DISPLAY_BG0_ACTIVE);
	vramSetMainBanks(VRAM_A_MAIN_BG_0x06000000, VRAM_B_LCD,
                     VRAM_C_SUB_BG , VRAM_D_LCD); 
                     
 
	
	
	
	BG3_CR = BG_BMP16_256x256;
	BG3_XDX = 1 << 7;
  BG3_XDY = 0;
  BG3_YDX = 0;
  BG3_YDY = 1 << 7;
  BG3_CX = 0;
  BG3_CY = 0;

	SUB_BG0_CR = BG_MAP_BASE(31);
	BG_PALETTE_SUB[255] = RGB15(31,31,31);	//by default font will be rendered with color 255
	consoleInitDefault((u16*)SCREEN_BASE_BLOCK_SUB(31), (u16*)CHAR_BASE_BLOCK_SUB(0), 16);
	
	
	lcdSwap();
	
	pceAppInit();
	
	// turn on the DS Motion Card
	motion_enable();
	
	IPC->aux ^= TURNOFF_BACKLIT_BOTTOM;

	while(1) {
		if(~REG_KEYINPUT & KEY_L) {
			IPC->aux ^= TURNOFF_BACKLIT_TOP;
			while(~REG_KEYINPUT & KEY_L);
		} 
		if(~REG_KEYINPUT & KEY_R) {
			IPC->aux ^= TURNOFF_BACKLIT_BOTTOM;
			while(~REG_KEYINPUT & KEY_R);
		}
		
		if((keysHeld()&KEY_SELECT) && !k_hit) { 
			lcdSwap();
			k_hit = 1;
		}
		if(!(keysHeld()&KEY_SELECT)) k_hit = 0;
		
		pceAppProc(cnt);
		cnt ++;
		swiWaitForVBlank();
		
		}

	return 0;
}
